using System;
using System.Xml;
using System.Configuration;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// Application configuration section handler class providing ability to 
	/// read list of servers from application configuration section.
	/// </summary>
	public class ServerListConfigSectionHandler : IConfigurationSectionHandler
	{
		/// <summary>
		/// Method deserializing and returning list of servers (connection information) from 
		/// application configuration file section.
		/// </summary>
		/// <param name="parent">The configuration settings in a corresponding parent configuration section. </param>
		/// <param name="configContext">
		///		Reserved by the interface.
		///	</param>
		/// <param name="section">Corresponding <see cref="XmlNode"/> section in configuration file.</param>
		/// <returns>
		///		List of servers (server connection information objects) deserialized 
		///		from application configuration section.
		///	</returns>
		public object Create( object parent, object configContext, XmlNode section )
		{
			return ServerConnectionInfoCollection.Parse( section );
		}

		/// <summary>
		/// Represents a name of a root element in config section processed by this handler.
		/// </summary>
		public static string SectionRootElementName
		{
			get
			{
				return ServerConnectionInfoCollection.CollectionXmlRootElementName;
			}
		}
	}
}
